if(tutorial_settings == nil) then
  tutorial_settings = {played = false}
end
local played_in_past = tutorial_settings.played
state:on_save(function(save)
  tutorial_settings.played = true
  save:set("tutorial_settings", tutorial_settings)
end)

state:suppress_toolbar_menu();
state:suppress_transport_menu();
state:suppress_interface_hints();

set_default_vertical(0.3)
function tutorial_routine_first()
  return coroutine.wrap(function()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Try this factory", 0.15))
    ))
    embed(pause_until(function() return state.grid:ticks() >= 5 end))
    embed(announce("Oops! Our bridge fell down.", 3, 0.1))
    embed(ramp_until(function() return false end, do_all(
      announce_lambda("Try again", 0.2),
      highlight_menu_item_lambda("stop_button")
    )))
  end)
end
local must_weld = resize.location.must_weld
local function get_missing_joints() --blocks needing joint on right
  local missing = {}
  for v in each_vector(must_weld) do
    local block = state.grid:at(v);
    assert(block)
    if not block.connections[RIGHT] then
      table.insert(missing, v)
    end
  end
  return missing
end
function is_done()
  return #get_missing_joints() == 0
end
function is_join_selected()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreateJoint" then
    return true
  end
end
local function only_open_join(i)
  return i.type == "JoinAction";
end
local function only_join_interaction(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.lmb_click or i.event == MouseEventAction.rmb_click then
      return true
    end
  elseif i.type == "MouseUpdateAction" then
    return true
  end
end
local function is_filling_gap()
  return is_join_selected() and not is_done()
end
local function draw_missing_joints(c, fade)
  local color = {1, 1, 0, fade.progress * 0.2 * bouncing_at_time(fade.total)}
  for _, v in pairs(get_missing_joints()) do
    local rect = c.viewport:world_to_view(Rectangled.new(0.4, -0.5, 0.6, 0.5):translate(v:as_vectord()))
    c:draw_rectangle(
      rect,
      color
    )
    draw_arrow_at_rect(
      c,
      rect,
      0.06 - 0.04 * bouncing_at_time(fade.total),
      c.viewport.zoom * 0.5,
      DOWN,
      {1, 1, 1, fade.progress}
    )
  end
end
function tutorial_routine_second()
  return coroutine.wrap(function()
    set_user_input_filter(restrictive_filter)
    embed(announce("Let's fix this factory.", 3, 0.1, captured_cancel()))
    state:suppress_toolbar_menu(false)
    embed(pause(0.5))
    while not is_done() do
      set_user_input_filter(only_open_join)
      embed(ramp_until(is_join_selected, do_all(
        announce_lambda("Tool: Join", 0.2),
        highlight_menu_item_lambda("toolbar_9")
      )))
      set_user_input_filter(only_join_interaction)
      embed(ramp_while(is_filling_gap, do_all(
        announce_lambda("Click and drag to weld", 0.1),
        draw_missing_joints
      )))
    end
    embed(tutorial_routine_finished())
  end)
end
function tutorial_routine_finished()
  return coroutine.wrap(function()
    state:suppress_toolbar_menu()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_or_cancel_filter)
    embed(ramp_while(is_join_selected, announce_lambda("Right click to exit join tool", 0.08)))
    set_user_input_filter(only_play_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.15))
    ))
    set_user_input_filter(only_play_or_stop_or_speed_filter)
    embed(pause_until(function() return state.grid:ticks() >= 20 end))
    embed(announce("It works!", 3, 0.2, captured_cancel()))
    function speed_is_low()
      return state:get_simulation_speed() < 1.5;
    end
    embed(pause(5))
    embed(ramp_while(speed_is_low, do_all(
      announce_lambda("Remember that you can adjust the speed.", 0.065),
      highlight_menu_item_lambda("speed_control")
    )))
  end)
end

function tutorial_routine()
  if not played_in_past then
    return tutorial_routine_first()
  elseif not is_done() then
    return tutorial_routine_second()
  else
    return tutorial_routine_finished()
  end
end


draw_interpreted_routine(tutorial_routine())

state:filter_interactions(function(i)
  return i.type == "Join"
end)
